module net.BurtonRadons.spyl.valueString;

private import net.BurtonRadons.spyl.value;

class StringValue : Value
{
    private import string;
    private import c.stdio;
    
    char [] content; /**< String content. */
    
    /** Assign the value, copying. */
    this (char [] content)
    {
        this.content = content.dup;
    }
    
    override char [] typeName ()
    {
        return "String";
    }
    
    override char [] str ()
    {
        return content;
    }
    
    override char [] repr ()
    {
        char [] text;
        
        text = '"';
        for (int c; c < content.length; c ++)
            switch (content [c])
            {
                case "\n": text ~= "\\n"; break;
                case "\r": text ~= "\\r"; break;
                case "\\": text ~= "\\"; break;
                case "\t": text ~= "\t"; break;
                case "\"": text ~= "\\\""; break;
                default:
                    if (content [c] >= 256)
                    {
                        char [6] buffer;
                        
                        sprintf (buffer, "\\u%04X", content [c]);
                        text ~= buffer;
                    }
                    else if (content [c] >= 128)
                    {
                        char [4] buffer;
                        
                        sprintf (buffer, "\\x%02X", content [c]);
                        text ~= buffer;
                    }
                    else
                        text ~= content [c];
            }
            
        return text ~ '"';
    }
    
    override Value opAdd (Value other)
    {
        if (cast (StringValue) other)
            return new StringValue (content ~ ((StringValue) other).content);
    }
    
    override Value getitem (int index)
    {
        return new StringValue (content [index .. index + 1]);
    }
    
    override Value getslice (Value min, Value max)
    {
        int imin, imax;
        
        if ((NullValue) min)
            imin = 0;
        else
            imin = ((IntegerValue) min.castTo (IntegerType.create ())).content;
        
        if ((NullValue) max)
            imax = content.length;
        else
            imax = ((IntegerValue) max.castTo (IntegerType.create ())).content;
            
        return new StringValue (content [imin .. imax]);
    }
}
